package de.test.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

public class main extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	public void writeInternally(View v) {
		String FILENAME = "hello_file";
		String string = "hello world!";

		FileOutputStream fos;
		try {
			fos = openFileOutput(FILENAME, Context.MODE_PRIVATE);
			fos.write(string.getBytes());
			fos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void listInternally(View v) {
		String[] files = fileList();
		for (int i = 0; i < files.length; i++) {
			Log.d("test", files[i].toString());
		}
	}

	public void readInternally(View v) {
		String FILENAME = "hello_file";

		FileInputStream fis;
		try {
			StringBuilder inb = new StringBuilder();
			fis = openFileInput(FILENAME);
			int chr;
			while ((chr = fis.read()) != -1) {
				inb.append((char) chr);
			}
			Toast.makeText(this, inb, Toast.LENGTH_SHORT).show();
			fis.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void writeExternally(View v) {
		String FILENAME = "hello_file";
		String string = "hello world!";

		try {
			File root = Environment.getExternalStorageDirectory();
			if (root.canWrite()) {
				File file = new File(root, FILENAME);
				FileWriter fos = new FileWriter(file);
				BufferedWriter out = new BufferedWriter(fos);
				out.write(string);
				out.close();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void readExternally(View v) {
		String FILENAME = "hello_file";

		try {
			File root = Environment.getExternalStorageDirectory();
			if (root.canRead()) {
				File file = new File(root, FILENAME);
				FileInputStream fis = new FileInputStream(file);
				BufferedReader in = new BufferedReader(new InputStreamReader(
						fis));
				String string = new String();

				while ((string = in.readLine()) != null) {
					Toast.makeText(this, string, Toast.LENGTH_SHORT).show();
				}

				in.close();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}